<?php

/**
 * @link https://www.humhub.org/
 * @copyright Copyright (c) HumHub GmbH & Co. KG
 * @license https://www.humhub.com/licences
 */

use humhub\helpers\Html;
use humhub\modules\custom_pages\modules\template\elements\ContainerElement;
use humhub\modules\custom_pages\modules\template\models\forms\EditItemForm;
use humhub\modules\custom_pages\modules\template\widgets\TemplateContentFormFields;
use humhub\widgets\bootstrap\Badge;
use humhub\widgets\modal\Modal;
use humhub\widgets\modal\ModalButton;

/* @var $model EditItemForm */
/* @var $action string */
/* @var $title string */
?>
<?php $form = Modal::beginFormDialog([
    'title' => $title,
    'size' => Modal::SIZE_LARGE,
    'footer' => ModalButton::cancel() .
        ModalButton::save()
            ->submit()
            ->action('editItemSubmit', null, '#templatePageRoot'),
    'form' => [
        'action' => $action,
        'enableClientValidation' => false,
    ],
]) ?>
<?= $form->field($model, 'submitFlag')->hiddenInput()->label(false) ?>

<div class="template-edit-multiple">

    <?php $counter = 0 ?>
    <?php foreach ($model->contentMap as $contentItem) : ?>

        <?php $isContainer = $contentItem->content instanceof ContainerElement; ?>

        <div class="panel panel-default">
            <div class="template-edit-multiple-tab panel-heading" tabindex="0">
                <strong>
                    <?= Html::encode($model->getElement($contentItem->elementContent->element->name)->getTitle()) ?>&nbsp;
                    <i class="switchIcon fa fa-caret-down" aria-hidden="true"></i>
                </strong>
                <?= Badge::success($contentItem->elementContent->getLabel())->right() ?>
                <?php if ($contentItem->content->isNewRecord): ?>
                    <?= Badge::warning(Yii::t('CustomPagesModule.view', 'Empty'))->right() ?>
                <?php endif; ?>
                <?php if ($isContainer && $contentItem->content->definition->allow_multiple): ?>
                    <?= Badge::success(Yii::t('CustomPagesModule.view', 'Multiple'))->right() ?>
                <?php endif; ?>
            </div>
            <?php // This was only set for container elements before. ?>
            <div class="panel-body<?= $counter != 0 ? ' d-none' : '' ?>" data-element-index="<?= $counter ?>">
                <?= TemplateContentFormFields::widget(['form' => $form, 'model' => $contentItem->content]) ?>
            </div>
            <div class="panel-footer">&nbsp;</div>
        </div>
        <?php $counter++ ?>
    <?php endforeach; ?>

    <?php if (empty($model->contentMap)) : ?>
        <div class="text-center">
            <?= Yii::t('CustomPagesModule.view', 'This section has no editable elements.') ?>
        </div>
    <?php endif; ?>

</div>
<?php Modal::endFormDialog() ?>
