<?php
/**
 * HumHub DAV Access
 *
 * @package humhub.modules.humdav
 * @author KeudellCoding
 */

namespace humhub\modules\humdav\components;

class UUIDHelper {
    public static function generateNew() {
        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        // 32 bits for "time_low"
        mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        // 16 bits for "time_mid"
        mt_rand(0, 0xffff),
        // 16 bits for "time_hi_and_version",
        // four most significant bits holds version number 4
        mt_rand(0, 0x0fff) | 0x4000,
        // 16 bits, 8 bits for "clk_seq_hi_res",
        // 8 bits for "clk_seq_low",
        // two most significant bits holds zero and one for variant DCE1.1
        mt_rand(0, 0x3fff) | 0x8000,
        // 48 bits for "node"
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff));
    }

    public static function generateNewFromStrings(...$params) {
        $value = md5(join('-', $params));
        $value = substr_replace($value, '4', 12, 1);

        $value = substr_replace($value, '-', 8, 0);
        $value = substr_replace($value, '-', 13, 0);
        $value = substr_replace($value, '-', 18, 0);
        $value = substr_replace($value, '-', 23, 0);

        return $value;
    }
}