<?php

/**
 * @link https://www.humhub.org/
 * @copyright Copyright (c) 2025 HumHub GmbH & Co. KG
 * @license https://www.humhub.com/licences
 */

namespace humhub\modules\letsMeet\models;

use Yii;
use yii\db\ActiveRecord;
use yii\helpers\ArrayHelper;

/**
 * @property int $id
 * @property string $date
 * @property int $meeting_id
 * @property-read Meeting $meeting
 * @property-read MeetingTimeSlot[] $timeSlots
 */
class MeetingDaySlot extends ActiveRecord
{
    public static function tableName()
    {
        return 'lets_meet_meeting_day_slot';
    }

    public function rules()
    {
        return [
            [['date', 'meeting_id'], 'required'],
            [['date'], 'safe'],
            [['meeting_id'], 'integer'],
        ];
    }

    public function getMeeting()
    {
        return $this->hasOne(Meeting::class, ['id' => 'meeting_id']);
    }

    public function getTimeSlots()
    {
        return $this->hasMany(MeetingTimeSlot::class, ['day_id' => 'id']);
    }

    public function afterDelete()
    {
        parent::afterDelete();

        MeetingVote::deleteAll(['time_slot_id' => ArrayHelper::getColumn($this->timeSlots, 'id')]);
    }
}
