<?php

/**
 * @link https://www.humhub.org/
 * @copyright Copyright (c) 2018 HumHub GmbH & Co. KG
 * @license https://www.humhub.com/licences
 *
 */

/**
 * Created by PhpStorm.
 * User: buddha
 * Date: 14.09.2017
 * Time: 20:44
 */

namespace humhub\modules\tasks\integration\calendar;

use humhub\modules\calendar\interfaces\AbstractCalendarQuery;
use humhub\modules\calendar\interfaces\FilterNotSupportedException;
use humhub\modules\tasks\models\scheduling\TaskScheduling;
use humhub\modules\tasks\models\Task;

class TaskCalendarQuery extends AbstractCalendarQuery
{
    /**
     * @inheritdoc
     */
    protected static $recordClass = Task::class;

    public $startField = 'start_datetime';
    public $endField = 'end_datetime';
    public $dateFormat = 'Y-m-d H:i:s';

    /**
     * @inheritdoc
     */
    public function filterIsParticipant()
    {
        $this->_query->leftJoin('task_user', 'task.id=task_user.task_id AND task_user.user_id=:userId', [':userId' => $this->_user->id]);
    }


    public function setupCriteria()
    {
        $this->_query
            ->andWhere(['task.scheduling' => 1])
            ->andWhere(['task.cal_mode' => TaskScheduling::CAL_MODE_SPACE])
            ->andWhere(['!=', 'task.status', Task::STATUS_COMPLETED]);

        parent::setupCriteria(); // TODO: Change the autogenerated stub
    }
}
