<?php

/**
 * @link https://www.humhub.org/
 * @copyright Copyright (c) 2018 HumHub GmbH & Co. KG
 * @license https://www.humhub.com/licences
 *
 */

namespace humhub\modules\tasks\notifications;

use Yii;
use humhub\modules\tasks\models\Task;
use humhub\modules\notification\components\BaseNotification;
use humhub\helpers\Html;

/**
 * Notifies an admin about reported content
 *
 * @since 0.5
 */
class RemindEnd extends BaseNotification
{
    /**
     * @inheritdoc
     */
    public $suppressSendToOriginator = false;

    /**
     * @inheritdoc
     */
    public $moduleId = 'tasks';

    /**
     * @inheritdoc
     */
    public $viewName = "remind";

    /**
     * @var Task
     */
    public $source;

    /**
     * @inheritdoc
     */
    public function category()
    {
        return new TaskReminderCategory();
    }

    public function html()
    {
        return Yii::t('TasksModule.base', 'Task {task} in space {spaceName} ends at {dateTime}.', [
            '{task}' => Html::tag('strong', Html::encode($this->getContentInfo($this->source, false))),
            '{spaceName}' => Html::tag('strong', Html::encode($this->source->content->container->displayName)),
            '{dateTime}' => Html::encode($this->source->schedule->getFormattedEndDateTime()),
        ]);

    }

    /**
     * @inheritdoc
     */
    public function getMailSubject()
    {
        return Yii::t('TasksModule.base', 'Task {task} in space {spaceName} ends at {dateTime}.', [
            '{task}' => Html::encode($this->getContentInfo($this->source, false)),
            '{spaceName}' => Html::encode($this->source->content->container->displayName),
            '{dateTime}' => Html::encode($this->source->schedule->getFormattedEndDateTime()),
        ]);
    }
}
